﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;
using Nintendo.ControlTarget.ConsoleShell;

namespace Nintendo.ControlTarget
{
    public class ResetCommand : CommonTargetCommand
    {
        [CommandLineOption("hard",
            Description = "Reset hardly.")]
        public bool ResetHard { get; set; }

        public override void Run()
        {
            RunHostBridgeTargetCommand(
                (name, info, target, tmapiAccessor) =>
                {
                    Trace.WriteLine($"Try to reset. name={name}, handle={info.GetTargetHandle()}");

                    if (info.GetConnectionType() == "USB")
                    {
                        var coodinator = new RunnerToolCoordinator(info.GetSerialNumber());

                        using (var targetOwnership = coodinator.RequestOwnership())
                        {
                            tmapiAccessor.ConnectTarget(info.GetTargetHandle());

                            System.Net.IPEndPoint endPoint;
                            try
                            {
                                endPoint = tmapiAccessor.FindService("iywys@$csForRunnerTools", info.GetTargetHandle());
                            }
                            catch (HtcServiceNotFound)
                            {
                                try
                                {
                                    endPoint = tmapiAccessor.FindService("@csForRunnerTools", info.GetTargetHandle());
                                }
                                catch (HtcServiceNotFound)
                                {
                                    throw new Exception("Found no shell service.");
                                }
                            }

                            Trace.WriteLine($"Try to connect: {endPoint.ToString()}");
                            var csAccessor = new ConsoleShellAccessor(new ConsoleShellMessenger(endPoint));
                            Trace.WriteLine($"Try to reset. serial={info.GetSerialNumber()}");
                            csAccessor.Reset();
                        }
                    }
                    else
                    {
                        if (ResetHard)
                        {
                            target.RebootHard();
                        }
                        else
                        {
                            target.Reboot();
                        }
                    }
                });
        }
    }
}
