﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;
using Nintendo.Bridge;

namespace Nintendo.ControlTarget
{
    public class PressPowerButtonCommand : CommonTargetCommand
    {
        [CommandLineOption("hold-time",
            Description = "Hold time (seconds).",
            DefaultValue = 1)]
        public int HoldTime { get; set; }

        public override void Run()
        {
            RunCommand(
                () =>
                {
                    using (var tmapiAccessor = new TargetManagerAccessor())
                    {
                        tmapiAccessor.EnsureStart();
                        var targetInfo = tmapiAccessor.FindTargetInfo(this.Target);

                        using (var target = tmapiAccessor.GetTarget(targetInfo.GetTargetHandle()))
                        {
                            if (targetInfo.GetHardwareType().StartsWith("EDEV"))
                            {
                                throw new Exception(string.Format("This function doesn't support {0}. Please use SDEV.", targetInfo.GetHardwareType()));
                            }
                            if (targetInfo.GetConnectionType() != "Ethernet")
                            {
                                throw new Exception("This function requires host bridge connection.");
                            }
                            Telnet hbTelnet = new Telnet();
                            if (!hbTelnet.Connect(targetInfo.GetIpAddress()))
                            {
                                throw new Exception("HostBridge connection failed.");
                            }
                            hbTelnet.Login();
                            string command = String.Format("ngpio_test -d 1 -p 1; ngpio_test -p 1 -w 1; sleep {0}; ngpio_test -p 1 -w 0", HoldTime);
                            hbTelnet.WaitCommand(command);
                            System.Threading.Thread.Sleep((HoldTime + 1) * 1000);
                        }
                    }
                });
        }
    }
}
