﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.IO;

namespace Nintendo.ControlTarget
{
    public class ListHtcsCommand
    {
        public static string Run()
        {
            using (var tma = new TargetManagerAccessor())
            {
                var rawXml = tma.ReadPortMappingXml();
                var xml = new XmlDocument();
                xml.LoadXml(rawXml);

                var settings = new XmlWriterSettings()
                {
                    Encoding = Encoding.Default,
                    Indent = true,
                    IndentChars = "    "
                };

                var stream = new MemoryStream();
                var writer = XmlWriter.Create(stream, settings);
                var reader = new System.IO.StreamReader(stream);

                xml.Save(writer);

                stream.Position = 0;

                return reader.ReadToEnd();
            }
        }
    }
}
