﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class GetDefaultCommand : CommonTargetManagerCommand
    {
        [CommandLineOption("xml",
            Description = "Output target infomations by XML.",
            DefaultValue = false)]
        public bool Xml { get; set; }

        [CommandLineOption("csv",
            Description = "Output target infomations by CSV.",
            DefaultValue = false)]
        public bool Csv { get; set; }

        public override void Run()
        {
            RunTargetManagerCommand(
                (tmapiAccessor) =>
                {
                    var target = tmapiAccessor.GetDefaultTarget();

                    var targets = target == null ?
                        new List<Tmapi.RegisteredTargetInfo>(){} :
                        new List<Tmapi.RegisteredTargetInfo>(){target};

                    if (Xml)
                    {
                        Console.WriteLine(TargetManagerAccessor.GetRegisteredTargetInfosAsXml(targets));
                    }
                    else if (Csv)
                    {
                        Console.WriteLine(TargetManagerAccessor.GetRegisteredTargetInfosAsCsv(targets));
                    }
                    else
                    {
                        if (target == null)
                        {
                            Console.WriteLine("no default target.");
                        }
                        else
                        {
                            Console.WriteLine(TargetManagerAccessor.GetTargetInfoText(target));
                        }
                    }
                });
        }
    }
}
