﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class EnableCradleCommand : CommonTargetCommand
    {
        public override void Run()
        {
            RunHostBridgeTargetCommand(
                (name, info, target, tmapiAccessor) =>
                {
                    var targetHandle = tmapiAccessor.FindTarget(name);
                    var targetInfo = tmapiAccessor.FindRegisteredTarget(targetHandle);
                    if (targetInfo != null)
                    {
                        if (targetInfo.GetHardwareType().StartsWith("EDEV"))
                        {
                            throw new Exception(string.Format("This function doesn't support {0}. Please use SDEV.", targetInfo.GetHardwareType()));
                        }

                        tmapiAccessor.EnableCradle(info.GetTargetHandle());
                    }
                    else
                    {
                        throw new Exception(string.Format("Found no targets. name = {0}", name));
                    }
                });
        }
    }
}
