﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;
using Nintendo.ControlTarget.ConsoleShell;

namespace Nintendo.ControlTarget
{
    public class EmulateThermalCommand : CommonTargetCommand
    {
        [CommandLineOption("normal",
            Description = "Disable emulation.")]
        public bool Normal { get; set; }

        [CommandLineOption("sleep",
            Description = "Emulate temperature to enter sleep.")]
        public bool Sleep { get; set; }

        Dictionary<string, int> TemparatureDictionary = new Dictionary<string, int>(){
            { "sleep", 84000 }
        };

        public override void Run()
        {
            RunHostBridgeTargetCommand(
                (name, info, target, tmapiAccessor) =>
                {
                    Trace.WriteLine($"Try to connect: {info.GetSerialNumber()}");

                    tmapiAccessor.ConnectTarget(info.GetTargetHandle());

                    System.Net.IPEndPoint endPoint;
                    try
                    {
                        endPoint = tmapiAccessor.FindService("iywys@$csForRunnerTools", info.GetTargetHandle());
                    }
                    catch (HtcServiceNotFound)
                    {
                        try
                        {
                            endPoint = tmapiAccessor.FindService("@csForRunnerTools", info.GetTargetHandle());
                        }
                        catch (HtcServiceNotFound)
                        {
                            throw new Exception("Found no shell service.");
                        }
                    }

                    Trace.WriteLine($"Try to connect: {endPoint.ToString()}");

                    var csAccessor = new ConsoleShellAccessor(new ConsoleShellMessenger(endPoint));

                    Trace.WriteLine($"Try to tarminate applications. serial={info.GetSerialNumber()}");

                    if (Normal)
                    {
                        Console.WriteLine("Set state : normal");
                        csAccessor.ControlVirtualTemperature(false, 0);
                    }
                    else if (Sleep)
                    {
                        Console.WriteLine("Set state : sleep");
                        csAccessor.ControlVirtualTemperature(true, TemparatureDictionary["sleep"]);
                    }
                    else
                    {
                        throw new Exception("No option. Please specify option.");
                    }
                });
        }
    }
}
