﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class ConnectCommand : CommonTargetCommand
    {
        [CommandLineOption("reset",
            Description = "Connect before reset the target.")]
        public bool Reset { get; set; }

        [CommandLineOption("timeout",
            Description = "Set timeout of connecting the target.",
            DefaultValue = 20)]
        public int Timeout { get; set; }

        public override void Run()
        {
            RunHostBridgeTargetCommand(
                (name, info, target, tmapiAccessor) =>
                {
                    Trace.WriteLine($"Try to connect. name={name}, handle={info.GetTargetHandle()}");

                    if (this.Reset)
                    {
                        target.Reboot();
                        Task.Delay(10000).Wait();
                    }

                    RetryUtility.Do(() =>
                    {
                        target.Connect();

                        if (!target.IsConnected())
                        {
                            throw new Exception("Not connected yet.");
                        }
                    },
                    (e) =>
                    {
                        Trace.WriteLine($"Failed to connect. reason: {e.Message}");
                    },
                    (es) =>
                    {
                        throw new Exception("Failed to connect.");
                    },
                    this.Timeout,
                    TimeSpan.FromSeconds(1));
                });
        }
    }
}
