﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;

namespace Nintendo.ControlTarget
{
    [Export(typeof(IGenericController))]
    [ExportMetadata("Priority", 90)]
    [ExportMetadata("ControlType", "ForceRecovery")]
    [ExportMetadata("HardwareType", "jetson-tk2")]
    [ExportMetadata("ControllerType", "Phidgets")]
    public class PhidgetForceRecorveryController : IGenericController
    {
        void IGenericController.Do()
        {
            PhidgetUtility.SendSignals(e =>
            {
                e.outputs[2] = false;   // Power を離す
                Task.Delay(100).Wait();
                e.outputs[0] = false;   // VolUp を離す
                Task.Delay(100).Wait();
                e.outputs[3] = false;   // Home を離す
                Task.Delay(100).Wait();
                e.outputs[0] = true;   // VolUp を押す
                Task.Delay(100).Wait();
                e.outputs[3] = true;   // Home を押す
                Task.Delay(100).Wait();
                e.outputs[2] = true;   // Power を押す
                Task.Delay(100).Wait();
                e.outputs[2] = false;   // Power を離す
                Task.Delay(100).Wait();
                e.outputs[0] = false;   // VolUp を離す
                Task.Delay(100).Wait();
                e.outputs[3] = false;   // Home を離す
                Task.Delay(100).Wait();
            });
        }
    }
}
