﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nn.Adl.Syntax;

namespace Nn.ResultTool
{
    public class ResultRange
    {
        public string Name { get; set; }
        public string Namespace { get; set; }
        public string Category { get; set; }
        public string Module { get; set; }
        public int Begin { get; set; }
        public int End { get; set; }
        public bool Abstract { get; set; }
        public string Text { get; set; }
        public ResultRange Parent { get; set; }
        public string Package { get; set; }
        public int Rank
        {
            get
            {
                var ret = 0;
                for (var p = this.Parent; p != null; p = p.Parent)
                {
                    ++ret;
                }
                return ret;
            }
        }

        public string FullName
        {
            get
            {
                return Namespace == null ? Name : string.Format(@"{0}::{1}", Namespace, Name);
            }
        }
    }
}
