﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nn.Adl.Syntax;

namespace Nn.Adl.Parsing
{
    public class ErrorHandlingSemanticAction
    {
        public void syntax_error(string expected)
        {
            throw new SyntaxErrorException(expected);
        }

        public void stack_overflow()
        {
            throw new ImplementationSupendedException();
        }
    }

    public class AdlCommonSubSemanticAction
    {
        private static class EmptyArray<T>
        {
            public static readonly T[] Value = new T[0];
        }

        private static T[] Single<T>(T x) { return new T[] { x }; }

        public Definition MakeDefinition(int pos, Identifier id, Expression expression)
        {
            return new Definition
            {
                DefineeName = id,
                ValueExpression = expression,
            };
        }

        public Document MakeDocument(int pos, IEnumerable<Statement> list)
        {
            return new Document
            {
                Statements = new EnumerableElement<Statement>(list.ToArray()),
            };
        }

        public Document MakeDocumentEmpty(int pos)
        {
            return MakeDocument(pos, EmptyArray<Statement>.Value);
        }

        public Statement MakeGroup(int pos, IEnumerable<Statement> statements)
        {
            return MakeGroup(pos, statements, EmptyArray<Modification>.Value);
        }

        public Statement MakeGroup(int pos, IEnumerable<Statement> statements, IEnumerable<Modification> modification)
        {
            return new Group
            {
                Statements = statements.ToArray(),
                Modifications = modification.ToArray(),
            };
        }

        public Statement MakeGroupEmpty(int pos)
        {
            return MakeGroup(pos, EmptyArray<Statement>.Value, EmptyArray<Modification>.Value);
        }

        public Statement MakeGroupEmpty(int pos, IEnumerable<Modification> modification)
        {
            foreach (var e in modification)
            {
                e.ModificationPosition = ModificationPosition.Group;
            }
            return MakeGroup(pos, EmptyArray<Statement>.Value, modification);
        }

        public Modification MakeModificationBody(int pos, Identifier id, Expression expression)
        {
            return new ValueModification
            {
                DefineeName = id,
                ValueExpression = expression,
            };
        }

        public Modification MakeModificationBody(int pos, Identifier id)
        {
            var ret = new NonValueModification
            {
                DefineeName = id,
            };
            return ret;
        }

        public IEnumerable<Modification> MakeModificationBodyList(int pos, IEnumerable<Modification> list, Modification one)
        {
            return list.Concat(Single(one));
        }

        public IEnumerable<Modification> MakeModificationBodyListSingle(int pos, Modification single)
        {
            single.Fix();
            return Single(single);
        }

        public IEnumerable<Modification> MakeModificationListEmpty(int pos)
        {
            return EmptyArray<Modification>.Value;
        }

        public IEnumerable<Modification> MakeModificationListSingle(int pos, IEnumerable<Modification> single)
        {
            return single;
        }

        public Statement MakeScopedModification(int pos, IEnumerable<Modification> scopedModification)
        {
            foreach (var e in scopedModification)
            {
                e.ModificationPosition = ModificationPosition.Scope;
            }
            return new ScopedModification
            {
                Modifications = scopedModification.ToArray(),
            };
        }

        public IEnumerable<Statement> MakeStatementList(int pos, IEnumerable<Statement> list, Statement one)
        {
            return list.Concat(Single(one));
        }

        public IEnumerable<Statement> MakeStatementListSingle(int pos, Statement single)
        {
            return Single(single);
        }

        public IEnumerable<Modification> MakeModificationList(int pos, IEnumerable<Modification> list)
        {
            return list;
        }

        public IEnumerable<Modification> MakeModificationList(int pos, IEnumerable<Modification> list, IEnumerable<Modification> one)
        {
            return list.Concat(one);
        }

        public Definition PushFrontModification(int pos, IEnumerable<Modification> modification, Definition definition)
        {
            foreach (var e in modification)
            {
                e.ModificationPosition = ModificationPosition.PreModify;
            }
            definition.PushFront(modification);
            return definition;
        }

        public Definition PushBackModification(int pos, Definition definition, IEnumerable<Modification> modification)
        {
            foreach (var e in modification)
            {
                e.ModificationPosition = ModificationPosition.PostModify;
            }
            definition.PushBack(modification);
            return definition;
        }

        public Statement MakeStatement(int pos, Definition x)
        {
            x.Fix();
            return x;
        }

        public Definition AddChildren(int pos, Definition definition, IEnumerable<Statement> children)
        {
            definition.Children = new EnumerableElement<Statement>(children);
            return definition;
        }

        public Modification AddModificationCategory(int pos, Modification modification, Identifier category)
        {
            modification.AddCategory(category);
            return modification;
        }

        public SyntaxElement MakeSyntaxElement(int pos)
        {
            return new SyntaxElement();
        }
    }
}
