﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nn.Adl.Evaluation
{
    public abstract class Value
    {
        public T GetValue<T>() { return (T)GetValue(); }
        public abstract object GetValue();
        public abstract string GetValueString();
        public Syntax.Expression SyntaxElement { get; internal set; }
    }

    public class ImmediateValue : Value
    {
        public override object GetValue()
        {
            return this.Value;
        }
        public object Value { get; set; }
        public override string GetValueString()
        {
            return this.Value.ToString();
        }
    }

    public interface IEvaluator { }

    public static class EvaluatorExtension
    {
        public static Value Evaluate(this IEvaluator evaluator, Semantics.Expression expression)
        {
            var ret = (Value)((dynamic)evaluator).EvaluateImpl((dynamic)expression);
            ret.SyntaxElement = expression.SyntaxElement;
            return ret;
        }
    }

    public class DefaultEvaluator : IEvaluator
    {
        protected internal Value EvaluateImpl(Semantics.Expression expression)
        {
            throw new ErrorException("unknown expression");
        }

        protected internal Value EvaluateImpl(Semantics.ImmediateExpression expression)
        {
            return new ImmediateValue
            {
                Value = expression.Value,
            };
        }
    }
}
