﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Threading;

namespace HalfAwakeLogMonitor
{
    class UartLogReader : IDisposable
    {
        private TcpClient m_Client;
        private NetworkStream m_Stream;
        private List<byte> m_Buffer;

        public UartLogReader(string hostname, int port)
        {
            m_Client = new TcpClient(hostname, port);
            m_Stream = m_Client.GetStream();
            m_Buffer = new List<byte>();
        }

        public string ReadLine()
        {
            var escaping = false;
            while (true)
            {
                // 1 行分の文字列を 1 文字ずつ溜めていく
                // 不要な文字は取り除く

                var b = m_Stream.ReadByte();

                if (b == -1)
                {
                    // ストリームが終端に到達
                    // 行の途中で到達したなら、それまでの文字列を返す
                    // 行頭で到達したなら、終端を表す null を返す

                    if (m_Buffer.Count > 0)
                    {
                        break;
                    }
                    else
                    {
                        return null;
                    }
                }

                if (b == 0x1b)
                {
                    escaping = true;
                    continue;
                }
                if (escaping)
                {
                    // TORIAEZU: エスケープシーケンスで色指定だけが行われていると仮定
                    if (b == 'm')
                    {
                        escaping = false;
                    }
                    continue;
                }

                if (b == '\n')
                {
                    // 改行コードは取り除く
                    // TORIAEZU: \n と \r\n の場合に対応

                    if (m_Buffer.LastOrDefault() == '\r')
                    {
                        m_Buffer.RemoveAt(m_Buffer.Count - 1);
                    }
                    break;
                }
                m_Buffer.Add((byte)(b & 0xff));
            }

            var line = new string(Encoding.UTF8.GetChars(m_Buffer.ToArray()));

            m_Buffer.Clear();

            return line;
        }

        public void Dispose()
        {
            m_Client.Close();
        }
    }
}
