﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;

namespace Nintendo.ManuHostTools.UsbLibrary
{
    public class UsbStream : Stream
    {
        private UsbSession session;
        private bool disposed = false;

        public UsbStream(UsbSession session)
        {
            this.session = session;
        }

        public override bool CanRead { get { return true; } }
        public override bool CanSeek { get { return false; } }
        public override bool CanWrite { get { return true; } }

        public override long Length { get { throw new NotSupportedException(); } }

        public override long Position
        {
            get { throw new NotSupportedException(); }
            set { throw new NotSupportedException(); }
        }

        public override void Flush()
        {
            // 送信をバッファリングしていないので、何もしない。
        }

        public override int Read(byte[] buffer, int offset, int count)
        {
            return this.session.Read(buffer, offset, count);
        }

        public override void Write(byte[] buffer, int offset, int count)
        {
            this.session.Write(buffer, offset, count);
        }

        public override long Seek(long offset, SeekOrigin origin)
        {
            throw new NotSupportedException();
        }

        public override void SetLength(long value)
        {
            throw new NotSupportedException();
        }

        public void Cancel()
        {
            try
            {
                this.session.Abort();
            }
            catch (OperationCanceledException)
            {
                // 既に切断されている
            }
        }

        protected override void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    // ここでマネージドリソースをDisposeする
                    this.Cancel();
                    this.session.Dispose();
                }

                // ここでアンマネージドリソースを解放する
                this.disposed = true;
            }

            base.Dispose(disposing);
        }
    }
}
