﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.ManuHostTools.UsbLibrary.Native
{
    public class ScopedHGlobal : IDisposable
    {
        private bool disposed;
        private IntPtr hglobal;

        public ScopedHGlobal(int length)
        {
            this.hglobal = Marshal.AllocHGlobal(length);
        }

        ~ScopedHGlobal()
        {
            this.Dispose(false);
        }

        public static implicit operator IntPtr(ScopedHGlobal scopedHglobal)
        {
            return scopedHglobal.hglobal;
        }

        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(this);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    // ここでマネージドリソースをDisposeする
                }

                // ここでアンマネージドリソースを解放する
                if (this.hglobal != null)
                {
                    Marshal.FreeHGlobal(this.hglobal);
                }

                this.disposed = true;
            }
        }
    }
}
