﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Reflection;

namespace MultipleRunFinalize
{
    internal class ProgramOption
    {
        public string SdkRootPath = Environment.GetEnvironmentVariable("NINTENDO_SDK_ROOT");

        public string BuildType = "Develop";
        public string Platform = "NX-NXFP2-a64";
        public string KeyType = "K5";
        public string BootType = "ManuBoot";
        public string SignedType = "Signed";
        public string StorageSize = "32G";
        public string DeveloperType = "ManufacturingTest";
        public string ConfigName = "TestWsIssuerServerConfig";
        public string FirstInitializeType = "None";
        public string ConnectionType = "Manu";
        public int FirstConnectTargetNum = 1;
        private string _LoggerPath = String.Empty;

        public string RunSystemInitializerManu
        {
            get{
                return Path.Combine(this.SdkRootPath, @"Tools\CommandLineTools\RunSystemInitializerManu.exe");
            }
            private set { }
        }
        public string TemporaryDirectoryRoot
        {
            get
            {
                return Path.Combine(SdkRootPath, @"Integrate\Outputs");
            }
            private set { }
        }
        public string ConfigPath
        {
            get
            {
                return Path.Combine(SdkRootPath, $"Integrate\\Sources\\Configs\\RequestToWsIssuerConfig\\{ConfigName}.yaml");
            }
            private set { }
        }
        public string LoggerPath
        {
            get
            {
                if (String.IsNullOrEmpty(_LoggerPath))
                {
                    return Path.Combine(SdkRootPath, @"Programs\Chris\Outputs\x86\Tools\ManuHostTools\Logger\Release\Logger.exe");
                }
                else
                {
                    return this._LoggerPath;
                }
            }
            private set { }
        }

        private static string GetOptionParameter(string[] args, int index)
        {
            if (index >= args.Length)
            {
                throw new Exception($"'{args[index - 1]}' option need argument.");
            }

            return args[index];
        }

        public static ProgramOption Parse(string[] args)
        {
            ProgramOption option = new ProgramOption();

            for (int i = 0; i < args.Length; ++i)
            {
                switch (args[i])
                {
                    case "-SdkRootPath":
                        {
                            option.SdkRootPath = Path.GetFullPath(GetOptionParameter(args, ++i));
                            break;
                        }
                    case "-BuildType":
                        {
                            option.BuildType = GetOptionParameter(args, ++i);
                            break;
                        }
                    case "-Platform":
                        {
                            option.Platform = GetOptionParameter(args, ++i);
                            break;
                        }
                    case "-KeyType":
                        {
                            option.KeyType = GetOptionParameter(args, ++i);
                            break;
                        }
                    case "-BootType":
                        {
                            option.BootType = GetOptionParameter(args, ++i);
                            break;
                        }
                    case "-SignedType":
                        {
                            option.SignedType = GetOptionParameter(args, ++i);
                            break;
                        }
                    case "-StorageSize":
                        {
                            option.StorageSize = GetOptionParameter(args, ++i);
                            break;
                        }
                    case "-DeveloperType":
                        {
                            option.DeveloperType = GetOptionParameter(args, ++i);
                            break;
                        }
                    case "-ConfigName":
                        {
                            option.ConfigName = GetOptionParameter(args, ++i);
                            break;
                        }
                    case "-FirstInitializeType":
                        {
                            option.FirstInitializeType = GetOptionParameter(args, ++i);
                            break;
                        }
                    case "-ConnectionType":
                        {
                            option.ConnectionType = GetOptionParameter(args, ++i);
                            break;
                        }
                    case "-FirstConnectTargetNum":
                        {
                            option.FirstConnectTargetNum = Int32.Parse(GetOptionParameter(args, ++i));
                            break;
                        }
                    case "-LoggerPath":
                        {
                            option._LoggerPath = Path.GetFullPath(GetOptionParameter(args, ++i));
                            break;
                        }
                    default:
                        throw new Exception($"Unknown option '{args[i]}'");
                }
            }

            return option;
        }

        public static void PrintUsage()
        {
            var ProgramAssembly = Assembly.GetEntryAssembly();
            var ProgramName = ProgramAssembly.ManifestModule.Name;

            Console.WriteLine("[{0} Ver.{1}]", ProgramName, ProgramAssembly.GetName().Version);
            Console.WriteLine("Usage : {0} [Option]", ProgramName);
            Console.WriteLine("Option");
            //Console.WriteLine("     -SdkRootPath <Path>      : SDK のルートパス");
        }
    }
}
