﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.ManuHostTools.UsbLibrary;

namespace Nintendo.ManuHostTools
{
    class Program
    {

        static void Main(string[] args)
        {
            var err = Program.Run(args);

            if (err.Id != ErrorCode.ErrorId.Success)
            {
                Console.Error.Write(err.ToString());
            }
            if (err.Id == ErrorCode.ErrorId.InvalidArgument)
            {
                Console.WriteLine();
                ProgramOption.PrintUsage();
            }

            System.Environment.ExitCode = (int)err.Id;
        }

        static ErrorCode Run(string[] args)
        {
            try
            {
                var option = new ProgramOption();
                ErrorCode errorCode;

                errorCode = ProgramOption.Parse(ref option, args);
                if (errorCode.Id != ErrorCode.ErrorId.Success)
                {
                    return errorCode;
                }

                var usbDevicePathList = UsbDevice.EnumerateDevicePathByGuid(option.UsbGuid);
                foreach (var devicePath in usbDevicePathList)
                {
                    var regex = new System.Text.RegularExpressions.Regex(@"(.*?)\{.*?\}$");
                    var match = regex.Match(devicePath);
                    Console.WriteLine("{0}", match.Groups[1].Value);
                }

                return ErrorCode.Success;
            }
            catch (Exception e)
            {
                return new ErrorCode(ErrorCode.ErrorId.UnhandledException, e.Message);
            }
        }
    }
}
