﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace Nintendo.ManuHostTools
{
    class ErrorCode
    {
        public static readonly ErrorCode Success = new ErrorCode(ErrorId.Success,String.Empty);

        public enum ErrorId : int
        {
            UnhandledException = -1,
            Success = 0,
            TooFewArgument = 1,
            InvalidArgument = 1,
        }

        public ErrorId Id;
        public string Message;

        public ErrorCode(ErrorId id, string message)
        {
            this.Initialize(id, message);
        }

        public ErrorCode(ErrorId id, string format, params Object[] objs)
        {
            this.Initialize(id, format, objs);
        }

        private void Initialize(ErrorId id, string format, params Object[] objs)
        {
            this.Initialize(id, String.Format(format, objs));
        }

        private void Initialize(ErrorId id, string message)
        {
            this.Id = id;
            this.Message = message;
        }

        public override string ToString()
        {
            if (this.Id == ErrorId.Success)
            {
                return String.Empty;
            }
            else
            {
                return String.Format("[ERROR] {0} (ErrorCode: {1})\n", Message, (int)Id);
            }
        }

        public void PrintError()
        {
            Console.Error.Write(this.ToString());
        }
    }
}
