﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class SvcStubHeaderGenerator : SourceGenerator
    {
        public SvcStubHeaderGenerator(CodeGenNames p) : base(p) { }

        public void Generate(SvcSet ss, Dictionary<string, AbiLayout> abi, string templatePath, string pathTemplate)
        {
            this.GenerateWithCategory(ss, abi, null, null, templatePath, pathTemplate);
        }

        protected string Namespace
        {
            get
            {
                return string.Format("{0}::{1}", CodeGenNames.UserCommonNamespace, Params.StubNamespace);
            }
        }

        protected override string Generate(CategorySet c,
            Dictionary<string, AbiLayout> abi,
            Dictionary<string, SvcLayout> svc,
            Dictionary<string, LayoutConversion> conv)
        {
            if (c.Operations == null)
            {
                return null;
            }

            var parts = c.Operations.Select(x => this.Generate(x, abi[x.Name]));
            var returnMaxLength = parts.Max(x => x.Item1.Length);
            var nameMaxLength   = parts.Max(x => x.Item2.Length);

            var lineFormat = string.Concat(
                "    {0,-", returnMaxLength, "} {1,-", nameMaxLength, "} {2};\r\n");

            var sb = new StringBuilder();
            sb.Append(SourceGenerator.MakePragmaOnce());
            sb.AppendLine();
            if (c.Includes != null)
            {
                foreach (var inc in c.Includes)
                {
                    sb.Append(SourceGenerator.MakeIncludeLine(inc));
                }
            }
            sb.AppendLine();
            sb.Append(SourceGenerator.MakeNameSpaceBeginText(this.Namespace));
            sb.AppendLine();

            foreach (var part in parts)
            {
                sb.AppendFormat(lineFormat, part.Item1, part.Item2, part.Item3);
            }

            sb.AppendLine();
            sb.Append(SourceGenerator.MakeNameSpaceEndText(this.Namespace));
            sb.AppendLine();
            return sb.ToString();
        }

        private Tuple<string, string, string> Generate(Operation op, AbiLayout al)
        {
            var paramText = GenerateParamText(op, al, false);

            return new Tuple<string, string, string>(
                op.ReturnType.Name,
                op.Name,
                paramText);
        }
    }
}
