﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace MakeSvcVeneer
{
    internal class CommandLineOption
    {
        public enum AbiTypes
        {
            NotSpecified,
            Arm333,     /// AArch32/ILP32 -> AArch32/ILP32
            Arm336,     /// AArch32/ILP32 -> AArch64/LP64
            Arm366,     /// AArch64/ILP32 -> AArch64/LP64
            Arm666,     /// AArch64/LP64  -> AArch64/LP64
        }

        public AbiTypes Abi { get; private set; }
        public string DefinitionPath { get; private set; }
        public string TemplatePath { get; private set; }
        public string OutIdPath { get; private set; }
        public string OutTypePath { get; private set; }
        public string OutStubHeaderPath { get; private set; }
        public string OutStubSourcePath { get; private set; }
        public string OutTablePath { get; private set; }
        public string OutHandlersPath { get; private set; }
        public string OutDriverHeaderPath { get; private set; }
        public string OutDriverSourcePath { get; private set; }
        public string OutRootPath { get; private set; }
        public string OutInclude { get; private set; }
        public string OutProfilerStubSourcePath { get; private set; }
        public string OutProfilerSourcePath { get; private set; }

        public CommandLineOption()
        {
        }

        private static AbiTypes DetectAbiType(string s)
        {
            switch (s)
            {
            case "arm333": return AbiTypes.Arm333;
            case "arm336": return AbiTypes.Arm336;
            case "arm366": return AbiTypes.Arm366;
            case "arm666": return AbiTypes.Arm666;
            }

            throw new ErrorException(
                string.Format("--abi に認識でない引数が渡されました ({0})", s));
        }

        public CommandLineOption(string[] args)
            : this()
        {
            CommandLineOptionParser.Parse(
                args,
                new List<CommandLineOptionParser.Option>()
                {
                    new CommandLineOptionParser.Option(
                        "def", x => DefinitionPath = x),
                    new CommandLineOptionParser.Option(
                        "abi", x => Abi = DetectAbiType(x)),
                    new CommandLineOptionParser.Option(
                        "template", x => TemplatePath = x),
                    new CommandLineOptionParser.Option(
                        "out_id", x => OutIdPath = x),
                    new CommandLineOptionParser.Option(
                        "out_type", x => OutTypePath = x),
                    new CommandLineOptionParser.Option(
                        "out_stub_header", x => OutStubHeaderPath = x),
                    new CommandLineOptionParser.Option(
                        "out_stub_source", x => OutStubSourcePath = x),
                    new CommandLineOptionParser.Option(
                        "out_table", x => OutTablePath = x),
                    new CommandLineOptionParser.Option(
                        "out_handlers", x => OutHandlersPath = x),
                    new CommandLineOptionParser.Option(
                        "out_driver_header", x => OutDriverHeaderPath = x),
                    new CommandLineOptionParser.Option(
                        "out_driver_source", x => OutDriverSourcePath = x),
                    new CommandLineOptionParser.Option(
                        "out_root", x => OutRootPath = x),
                    new CommandLineOptionParser.Option(
                        "out_include", x => OutInclude = x),
                    new CommandLineOptionParser.Option(
                        "out_profiler_stub_source", x => OutProfilerStubSourcePath = x),
                    new CommandLineOptionParser.Option(
                        "out_profiler_source", x => OutProfilerSourcePath = x),
                });
        }
    }
}
