﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class CodeGenNames
    {
        public const string IdNamePrefix = "NN_SVC_ID_";
        public const string UserCommonNamespace = "nn::svc";
        public const string KernelCommonNamespace = "nn::kern::svc";
        public const string HandlerTableCommon = "nnkernServiceTable";
        public const string DriverNamePrefix = "Call";
        public const string HandlerNamePrefix = "Svc";
        public const string UserPointerWrapperClassName = "KUserPointer";

        public string TypeNamespace { get; private set; }
        public string StubNamespace { get; private set; }
        public string HandlerTableName { get; private set; }
        public string HandlerNamePostfix { get; private set; }
        public string DriverClassName { get; private set; }

        private CodeGenNames(string tn, string sn, string htp, string hnf, string dcn)
        {
            TypeNamespace = tn;
            StubNamespace = sn;
            HandlerTableName = HandlerTableCommon + htp;
            HandlerNamePostfix = hnf;
            DriverClassName = dcn;
        }

        public static readonly CodeGenNames Arm333 =
            new CodeGenNames("ilp32", "aarch32", "Aarch32", "32", "Aarch32");

        public static readonly CodeGenNames Arm336 =
            new CodeGenNames("ilp32", "aarch32", "Aarch64From32", "64From32", "Aarch64From32");

        public static readonly CodeGenNames Arm366 =
            new CodeGenNames("lp64", "aarch64::ilp32", "Aarch64", "64", "Aarch64");

        public static readonly CodeGenNames Arm666 =
            new CodeGenNames("lp64", "aarch64::lp64", "Aarch64", "64", "Aarch64");

        public static readonly CodeGenNames Arm333p =
            new CodeGenNames("ilp32", "aarch32::profiler", "Aarch32", "32", "Aarch32");

        public static readonly CodeGenNames Arm336p =
            new CodeGenNames("ilp32", "aarch32::profiler", "Aarch64From32", "64From32", "Aarch64From32");

        public static readonly CodeGenNames Arm366p =
            new CodeGenNames("lp64", "aarch64::ilp32::profiler", "Aarch64", "64", "Aarch64");

        public static readonly CodeGenNames Arm666p =
            new CodeGenNames("lp64", "aarch64::lp64::profiler", "Aarch64", "64", "Aarch64");
    }
}
