﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class PredefinedTypes
    {
        public class TypeInfo
        {
            private const int PointerSize = 1000000;
            private const int RegisterSize = 1000001;

            public string Name { get; private set; }
            public string Namespace { get; private set; }
            public int Size { get; private set; }
            public bool IsPointerSize { get { return Size == PointerSize; } }
            public bool IsRegisterSize { get { return Size == RegisterSize; } }

            public TypeInfo(string n, int s)
            {
                Name = n;
                Size = s;
                Namespace = string.Empty;
            }
            public TypeInfo(string n, int s, string ns)
            {
                Name = n;
                Size = s;
                Namespace = ns;
            }
            public static TypeInfo MakePointerSizeType(string n)
            {
                return new TypeInfo(n, PointerSize);
            }
            public static TypeInfo MakeRegisterSizeType(string n)
            {
                return new TypeInfo(n, RegisterSize);
            }
        }

        public static Dictionary<string, string> GetReplaceMap(int registerSize, int pointerSize)
        {
            if (registerSize == 4 && pointerSize == 4)
            {
                return new Dictionary<string, string>()
                {
                    { "size_t", "Size32" },
                    { "uintptr_t", "UIntPtr32" },
                    { "regtype_t", "RegType32" },
                };
            }
            else if (registerSize == 8)
            {
                if (pointerSize == 4)
                {
                    return new Dictionary<string, string>()
                    {
                        { "size_t", "Size32" },
                        { "uintptr_t", "UIntPtr32" },
                        { "regtype_t", "RegType64" },
                    };
                }
                else if (pointerSize == 8)
                {
                    return new Dictionary<string, string>()
                    {
                        { "size_t", "Size64" },
                        { "uintptr_t", "UIntPtr64" },
                        { "regtype_t", "RegType64" },
                    };
                }
            }

            throw new ErrorException("サポートしていないポインタサイズです");
        }

        public static TypeInfo[] List
        {
            get
            {
                return new TypeInfo[]
                {
                    new TypeInfo("Bit8",        1, "nn"),
                    new TypeInfo("Bit16",       2, "nn"),
                    new TypeInfo("Bit32",       4, "nn"),
                    new TypeInfo("Bit64",       8, "nn"),
                    new TypeInfo("Bit128",     16, "nn"),
                    new TypeInfo("char",        1),
                    new TypeInfo("char16_t",    2),
                    new TypeInfo("int8_t",      1),
                    new TypeInfo("int16_t",     2),
                    new TypeInfo("int32_t",     4),
                    new TypeInfo("Result",      4, "nn"),
                    new TypeInfo("int64_t",     8),
                    new TypeInfo("uint8_t",     1),
                    new TypeInfo("uint16_t",    2),
                    new TypeInfo("uint32_t",    4),
                    new TypeInfo("uint64_t",    8),
                    new TypeInfo("void",        0),
                    new TypeInfo("bool",        1),
                    TypeInfo.MakePointerSizeType("size_t"),
                    TypeInfo.MakePointerSizeType("uintptr_t"),
                    TypeInfo.MakeRegisterSizeType("regtype_t"),
                };
            }
        }
    }
}
