﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class LayoutConversionOperationLoad : LayoutConversion.Operation
    {
        // ABI: スタック
        // SVC: レジスタ

        public LayoutConversionOperationLoad(int abiIndex, int svcIndex, int storageSize, string name)
            : base("Load", abiIndex, new int[] { svcIndex }, storageSize, storageSize, name)
        {
        }

        public override void GenerateCodeInAbiToSvc(
            CodeGenerator cg, RegisterUsageTracer tracer, int stackOffset)
        {
            var abiOffset = stackOffset + (AbiIndex * StorageSize);

            tracer.Occupy(this.SvcIndex[0], "svc " + this.VariableName);
            cg.LoadFromStack(this.SvcIndex[0], abiOffset, this.VariableName + " の値");
        }
        public override bool CanGenerateCodeInSvcToAbi(RegisterUsageTracer tracer)
        {
            return true;
        }
        public override void GenerateCodeInSvcToAbi(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            tracer.Release(this.SvcIndex[0]);
            cg.StoreToStack(this.SvcIndex[0], this.AbiIndex * this.StorageSize, this.VariableName + " の値");
        }
        public override void GenerateCodeOutPrepareToAbi(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            throw new ErrorException("呼び出されないはずの関数");
        }
        public override void GenerateCodeOutAbiToSvc(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            throw new ErrorException("呼び出されないはずの関数");
        }
        public override void GenerateCodeOutSvcToAbi(
            CodeGenerator cg,
            RegisterUsageTracer tracer,
            Dictionary<int, int> saveMap,
            int safeRegister,
            int stackOffset)
        {
            throw new ErrorException("呼び出されないはずの関数");
        }
    }
}
