﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal static class Extensions
    {
        public static int IndexOfLineHead(this string s)
        {
            return s.IndexOfLineHead(0);
        }

        /// <summary>
        /// 指定された位置から後方で最も近い行頭の位置を返します。
        /// </summary>
        /// <param name="s">対象の文字列</param>
        /// <param name="start">探索を開始する位置</param>
        /// <returns>改行が見つかった場合は改行と次の行の先頭の間を指すの位置を返します。
        /// 見つからなかった場合は負の値を返します。</returns>
        public static int IndexOfLineHead(this string s, int start)
        {
            var found = s.IndexOfAny(new char[] { '\n', '\r' }, start);

            if (found < 0)
            {
                return found;
            }
            if (s[found] == '\r'
                && found + 1 < s.Length
                && s[found + 1] == '\n')
            {
                return found + 2;
            }

            return found + 1;
        }

        /// <summary>
        /// 指定された位置から後方で最も近い行末の位置を返します。
        /// </summary>
        /// <param name="s">対象の文字列</param>
        /// <param name="start">探索を開始する位置</param>
        /// <returns>改行が見つかった場合は改行の直前の位置を返します。
        /// 見つからなかった場合は文字列の末尾の位置を返します。</returns>
        public static int IndexOfLineEnd(this string s, int start)
        {
            var found = s.IndexOfAny(new char[] { '\n', '\r' }, start);
            return (found >= 0) ? found : s.Length;
        }

        /// <summary>
        /// 指定された位置から前方で最も近い行頭位置を返します。
        /// </summary>
        /// <param name="s">対象の文字列</param>
        /// <param name="start">探索を開始する位置</param>
        /// <returns>改行が見つかった場合は改行と次の行の先頭の間を指す位置を返します。
        /// 見つからなかった場合は 0 を返します</returns>
        public static int LastIndexOfLineHead(this string s, int start)
        {
            if (start <= 0)
            {
                return 0;
            }

            // start の位置に改行があるとそれがヒットしてしまうため
            // -1 する
            --start;

            var found = s.LastIndexOfAny(new char[] { '\n', '\r' }, start);
            return (found < 0) ? 0 : found + 1;
        }

        /// <summary>
        /// 指定された位置から前方で最も近い行末の位置を返します。
        /// </summary>
        /// <param name="s">対象の文字列</param>
        /// <param name="start">探索を開始する位置</param>
        /// <returns>改行が見つかった場合は改行の直前の位置を返します。
        /// 見つからなかった場合は負の値を返します</returns>
        public static int LastIndexOfLineEnd(this string s, int start)
        {
            // start の位置に改行があるとそれがヒットしてしまうため
            // -1 する
            if (start > 0)
            {
                --start;
            }
            var found = s.LastIndexOfAny(new char[] { '\n', '\r' }, start);
            if (found < 0)
            {
                return found;
            }
            if (s[found] == '\n'
                && found - 1 >= 0
                && s[found - 1] == '\r')
            {
                return found - 1;
            }
            return found;
        }

        public static Stack<T> Clone<T>(this Stack<T> src)
        {
            return new Stack<T>(src.Reverse());
        }

        public static bool IsEmpty<T>(this IEnumerable<T> list)
        {
            foreach (var x in list)
            {
                return false;
            }
            return true;
        }
        public static bool HasItem<T>(this IEnumerable<T> list)
        {
            foreach (var x in list)
            {
                return true;
            }
            return false;
        }
        public static bool HasOnlyOneItem<T>(this IEnumerable<T> list)
        {
            bool isOne = false;

            foreach (var x in list)
            {
                if (isOne)
                {
                    return false;
                }
                isOne = true;
            }
            return isOne;
        }

        public static void ForEach<T>(
            this IEnumerable<T> list,
            Action<T> f)
        {
            foreach (var e in list)
            {
                f(e);
            }
        }

        public static int FindIndex<T>(this IEnumerable<T> list,
            Func<T, bool> f)
        {
            int i = 0;
            foreach (var e in list)
            {
                if (f(e))
                {
                    return i;
                }
                i++;
            }
            return -1;
        }

        public static IEnumerable<T> Add<T>(this IEnumerable<T> list, T item)
        {
            return list.Concat(new T[] { item });
        }
    }
}
