﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class CrossDictionary<A, B>
    {
        private Dictionary<A, B> m_normalMap = new Dictionary<A, B>();
        private Dictionary<B, A> m_reverseMap = new Dictionary<B, A>();

        public void Add(A a, B b)
        {
            m_normalMap.Add(a, b);

            try
            {
                m_reverseMap.Add(b, a);
            }
            catch (ArgumentException)
            {
                m_normalMap.Remove(a);
                throw;
            }
        }
        public B GetNormal(A a)
        {
            return m_normalMap[a];
        }
        public A GetReverse(B b)
        {
            return m_reverseMap[b];
        }
        public B this[A a]
        {
            get { return GetNormal(a); }
        }
        public A this[B b]
        {
            get { return GetReverse(b); }
        }
    }
}
