﻿using System;
using System.IO;
using System.Xml;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.CompilerServices;

[assembly: InternalsVisibleTo("MakeNrrTest")]
namespace MakeNrr
{
    class Program
    {
        internal static void Main(string[] args)
        {
            if (Directory.Exists(Path.Combine(Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location), "en")))
            {
                System.Threading.Thread.CurrentThread.CurrentUICulture = new System.Globalization.CultureInfo("en", false);
            }

            MakeNrrArgs opt = new MakeNrrArgs();

            try
            {
                if (!opt.ParseArgs(args))
                {
                    return;
                }
            }
            catch
            {
                Environment.ExitCode = 1;
                return;
            }

            try
            {
                Nrr nrr = new Nrr();
                nrr.GenerateNrr(opt.Params.NroFilePaths);

                using (FileStream fs = new FileStream(opt.Params.OutputFilePath, FileMode.Create, FileAccess.Write))
                {
                    fs.Write(nrr.NroFileBinary, 0, nrr.NroFileBinary.Length);
                }
            }
            catch (Exception ex)
            {
                Console.Error.Write("MakeNrr ");
                foreach (var arg in args)
                {
                    Console.Error.Write(arg + " ");
                }
                Console.Error.WriteLine();
                Console.Error.WriteLine(ex.Message);
                Environment.ExitCode = 1;
                return;
            }
        }
    }
}
