﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace MakeNrr
{
    class MakeNrrArgs
    {
        private MakeNrrParams parameters;
        public MakeNrrParams Params
        {
            get { return parameters; }
        }

        /// <summary>
        /// プログラムの引数からパラメータを設定します。
        /// </summary>
        /// <param name="args">プログラムの引数</param>
        /// <returns>パラメータ設定の可否</returns>
        public bool ParseArgs(string[] args)
        {
            var setttings = new CommandLineParserSettings()
            {
                ApplicationDescription = "MakeNrr generates NRR file from NRO files.",
                HelpWriter = text =>
                {
                    Console.WriteLine(text);
                },
            };

            if (!new CommandLineParser(setttings).ParseArgs(args, out parameters))
            {
                return false;
            }

            return true;
        }
    }
}
