﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace MakeNro.Elf
{
    /// <summary>
    /// ElfMachineType の拡張メソッドを定義します。
    /// </summary>
    public static class ElfMachineTypeExtensions
    {
        /// <summary>
        /// ELF ファイルのマシンタイプが 64 bit アーキテクチャかどうかを示す値を取得します。
        /// </summary>
        /// <param name="machine">ELF ファイルのマシンタイプです。</param>
        /// <returns>64 bit アーキテクチャかどうかを示す値です。</returns>
        public static bool Is64bit(this ElfMachineType machine)
        {
            switch (machine)
            {
                case ElfMachineType.AArch64:
                    return true;
                default:
                    return false;
            }
        }
    }
}
