﻿using System;
using System.Xml;
using System.Collections.Generic;

namespace DescModel
{
    [System.Xml.Serialization.XmlRoot("FsAccessControlDescriptor")]
    public class FaDescriptorModel
    {
        [System.Xml.Serialization.XmlElement("FlagPresets")]
        public List<string> FlagPresets { get; set; }

        [System.Xml.Serialization.XmlIgnore]
        public UInt64 ContentOwnerIdMinValue { get; set; }
        private string _ContentOwnerIdMin;

        [System.Xml.Serialization.XmlElement("ContentOwnerIdMin")]
        public string ContentOwnerIdMin
        {
            get { return _ContentOwnerIdMin; }
            set
            {
                if (value == null)
                {
                    return;
                }
                ContentOwnerIdMinValue = ConvertUtils.ConvertHexString(value, "FsAccessControlDescriptor/ContentOwnerIdMin");
                _ContentOwnerIdMin = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public UInt64 ContentOwnerIdMaxValue { get; set; }
        private string _ContentOwnerIdMax;

        [System.Xml.Serialization.XmlElement("ContentOwnerIdMax")]
        public string ContentOwnerIdMax
        {
            get { return _ContentOwnerIdMax; }
            set
            {
                if (value == null)
                {
                    return;
                }
                ContentOwnerIdMaxValue = ConvertUtils.ConvertHexString(value, "FsAccessControlDescriptor/ContentOwnerIdMax");
                _ContentOwnerIdMax = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public UInt64 SaveDataOwnerIdMinValue { get; set; }
        private string _SaveDataOwnerIdMin;

        [System.Xml.Serialization.XmlElement("SaveDataOwnerIdMin")]
        public string SaveDataOwnerIdMin
        {
            get { return _SaveDataOwnerIdMin; }
            set
            {
                if (value == null)
                {
                    return;
                }
                SaveDataOwnerIdMinValue = ConvertUtils.ConvertHexString(value, "FsAccessControlDescriptor/SaveDataOwnerIdMin");
                _SaveDataOwnerIdMin = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public UInt64 SaveDataOwnerIdMaxValue { get; set; }
        private string _SaveDataOwnerIdMax;

        [System.Xml.Serialization.XmlElement("SaveDataOwnerIdMax")]
        public string SaveDataOwnerIdMax
        {
            get { return _SaveDataOwnerIdMax; }
            set
            {
                if (value == null)
                {
                    return;
                }
                SaveDataOwnerIdMaxValue = ConvertUtils.ConvertHexString(value, "FsAccessControlDescriptor/SaveDataOwnerIdMax");
                _SaveDataOwnerIdMax = value;
            }
        }

        [System.Xml.Serialization.XmlElement("ContentOwnerIds")]
        public List<string> ContentOwnerIds { get; set; }

        [System.Xml.Serialization.XmlElement("SaveDataOwnerIds")]
        public List<string> SaveDataOwnerIds { get; set; }
    }
}
