﻿using System;
using System.Xml;
using System.Collections.Generic;

namespace DescModel
{
    public class SaveDataOwnerId
    {
        [System.Xml.Serialization.XmlIgnore]
        public byte AccessibilityValue { get; set; }
        private string _Accessibility;

        [System.Xml.Serialization.XmlElement("Accessibility")]
        public string Accessibility
        {
            get { return _Accessibility; }
            set
            {
                if (value == null)
                {
                    return;
                }
                switch (value)
                {
                    case "Read":
                        AccessibilityValue = 1;
                        break;
                    case "Write":
                        AccessibilityValue = 2;
                        break;
                    case "ReadWrite":
                        AccessibilityValue = 3;
                        break;
                    default:
                        throw new ArgumentException();
                }
                _Accessibility = value;
            }
        }

        [System.Xml.Serialization.XmlElement("Id")]
        public string Id { get; set; }
    }

    [System.Xml.Serialization.XmlRoot("FsAccessControlData")]
    public class FaDataModel
    {
        [System.Xml.Serialization.XmlElement("FlagPresets")]
        public List<string> FlagPresets { get; set; }

        [System.Xml.Serialization.XmlElement("ContentOwnerIds")]
        public List<string> ContentOwnerIds { get; set; }

        [System.Xml.Serialization.XmlElement("SaveDataOwnerIds")]
        public List<SaveDataOwnerId> SaveDataOwnerIds { get; set; }
    }
}
