﻿using System;
using System.Collections.Generic;

namespace DescModel
{
    [System.Xml.Serialization.XmlRoot("Default", IsNullable=false)]
    public class DefaultModel
    {
        [System.Xml.Serialization.XmlIgnore]
        public bool Is64BitInstructionValue { get; set; }
        private string _Is64BitInstruction;
        [System.Xml.Serialization.XmlElement("Is64BitInstruction", IsNullable=false)]
        public string Is64BitInstruction
        {
            get { return _Is64BitInstruction; }
            set
            {
                if (value == null)
                {
                    return;
                }
                Is64BitInstructionValue = ConvertUtils.ConvertBoolString(value, "Default/Is64BitInstruction");
                _Is64BitInstruction = Convert.ToBoolean(Is64BitInstructionValue).ToString();
            }
        }

        public const string AddressSpace32Bit = "AddressSpace32Bit";
        public const string AddressSpace64Bit = "AddressSpace64Bit";
        public const string AddressSpace64BitOld = "AddressSpace64BitOld";
        public const string AddressSpace32BitNoReserved = "AddressSpace32BitNoReserved";
        private string _ProcessAddressSpace;
        [System.Xml.Serialization.XmlElement("ProcessAddressSpace", IsNullable=false)]
        public string ProcessAddressSpace
        {
            get { return _ProcessAddressSpace; }
            set
            {
                switch (value)
                {
                    case AddressSpace32Bit:
                        _ProcessAddressSpace = value;
                        break;
                    case AddressSpace64BitOld:
                        _ProcessAddressSpace = value;
                        break;
                    case AddressSpace32BitNoReserved:
                        _ProcessAddressSpace = value;
                        break;
                    case AddressSpace64Bit:
                        _ProcessAddressSpace = value;
                        break;
                    default:
                        throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidArgumentString, "Default/ProcessAddressSpace", value));
                }
            }
        }

        public const byte LowestThreadPriority = 63;
        public const byte HighestThreadPriority = 0;
        [System.Xml.Serialization.XmlIgnore]
        public byte MainThreadPriorityValue { get; set; }
        private string _MainThreadPriority;
        [System.Xml.Serialization.XmlElement("MainThreadPriority", IsNullable=false)]
        public string MainThreadPriority
        {
            get { return _MainThreadPriority; }
            set
            {
                if (value == null)
                {
                    return;
                }
                MainThreadPriorityValue = checked((byte)ConvertUtils.ConvertDecimalString(value, "Default/MainThreadPriority"));
                if (MainThreadPriorityValue < HighestThreadPriority || MainThreadPriorityValue > LowestThreadPriority)
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_OutOfRange, "Default/MainThreadPriority", value));
                }
                _MainThreadPriority = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public byte MainThreadCoreNumberValue { get; set; }
        private string _MainThreadCoreNumber;
        [System.Xml.Serialization.XmlElement("MainThreadCoreNumber", IsNullable=false)]
        public string MainThreadCoreNumber
        {
            get { return _MainThreadCoreNumber; }
            set
            {
                if (value == null)
                {
                    return;
                }
                MainThreadCoreNumberValue = checked((byte)ConvertUtils.ConvertDecimalString(value, "Default/MainThreadCoreNumber"));
                _MainThreadCoreNumber = value;
            }
        }

        public const uint AlignMainThraedStackSize = 0x1000;
        [System.Xml.Serialization.XmlIgnore]
        public uint MainThreadStackSizeValue { get; set; }
        private string _MainThreadStackSize;
        [System.Xml.Serialization.XmlElement("MainThreadStackSize", IsNullable=false)]
        public string MainThreadStackSize
        {
            get { return _MainThreadStackSize; }
            set
            {
                if (value == null)
                {
                    return;
                }
                MainThreadStackSizeValue = checked((uint)ConvertUtils.ConvertHexString(value, "Default/MainThreadStackSize"));
                if ((MainThreadStackSizeValue & (AlignMainThraedStackSize - 1)) > 0)
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidAlignment, "Default/MainThreadStackSize", AlignMainThraedStackSize));
                }
                if (MainThreadStackSizeValue == 0)
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_Invalid0, "Default/MainThreadStackSize"));
                }
                _MainThreadStackSize = value;
            }
        }

        [System.Xml.Serialization.XmlElement("FsAccessControlData")]
        public FaDataModel  FsAccessControlData { get; set; }

        [System.Xml.Serialization.XmlElement("SrvAccessControlData")]
        public SaDataModel SrvAccessControlData { get; set; }

        [System.Xml.Serialization.XmlElement("KernelCapabilityData")]
        public KcDataModel KernelCapabilityData { get; set; }

        public void CheckReadSuccess()
        {
            if (Is64BitInstruction == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Default/Is64BitInstruction"));
            }
            if (ProcessAddressSpace == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Default/ProcessAddressSpace"));
            }
            if (MainThreadPriority == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Default/MainThreadPriority"));
            }
            if (MainThreadCoreNumber == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Default/MainThreadCoreNumber"));
            }
            if (MainThreadStackSize == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Default/MainThreadStackSize"));
            }
        }
    }

    public class DefaultModelWithSvcInfo
    {
        [System.Xml.Serialization.XmlIgnore]
        public bool Is64BitInstructionValue { get; set; }
        private string _Is64BitInstruction;
        [System.Xml.Serialization.XmlElement("Is64BitInstruction", IsNullable=false)]
        public string Is64BitInstruction
        {
            get { return _Is64BitInstruction; }
            set
            {
                if (value == null)
                {
                    return;
                }
                Is64BitInstructionValue = ConvertUtils.ConvertBoolString(value, "Default/Is64BitInstruction");
                _Is64BitInstruction = Convert.ToBoolean(Is64BitInstructionValue).ToString();
            }
        }

        public const string AddressSpace32Bit = "AddressSpace32Bit";
        public const string AddressSpace64Bit = "AddressSpace64Bit";
        public const string AddressSpace64BitOld = "AddressSpace64BitOld";
        public const string AddressSpace32BitNoReserved = "AddressSpace32BitNoReserved";
        private string _ProcessAddressSpace;
        [System.Xml.Serialization.XmlElement("ProcessAddressSpace", IsNullable=false)]
        public string ProcessAddressSpace
        {
            get { return _ProcessAddressSpace; }
            set
            {
                switch (value)
                {
                    case AddressSpace32Bit:
                        _ProcessAddressSpace = value;
                        break;
                    case AddressSpace64BitOld:
                        _ProcessAddressSpace = value;
                        break;
                    case AddressSpace32BitNoReserved:
                        _ProcessAddressSpace = value;
                        break;
                    case AddressSpace64Bit:
                        _ProcessAddressSpace = value;
                        break;
                    default:
                        throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidArgumentString, "Default/ProcessAddressSpace", value));
                }
            }
        }

        public const byte LowestThreadPriority = 63;
        public const byte HighestThreadPriority = 0;
        [System.Xml.Serialization.XmlIgnore]
        public byte MainThreadPriorityValue { get; set; }
        private string _MainThreadPriority;
        [System.Xml.Serialization.XmlElement("MainThreadPriority", IsNullable=false)]
        public string MainThreadPriority
        {
            get { return _MainThreadPriority; }
            set
            {
                if (value == null)
                {
                    return;
                }
                MainThreadPriorityValue = checked((byte)ConvertUtils.ConvertDecimalString(value, "Default/MainThreadPriority"));
                if (MainThreadPriorityValue < HighestThreadPriority || MainThreadPriorityValue > LowestThreadPriority)
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_OutOfRange, "Default/MainThreadPriority", value));
                }
                _MainThreadPriority = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public byte MainThreadCoreNumberValue { get; set; }
        private string _MainThreadCoreNumber;
        [System.Xml.Serialization.XmlElement("MainThreadCoreNumber", IsNullable=false)]
        public string MainThreadCoreNumber
        {
            get { return _MainThreadCoreNumber; }
            set
            {
                if (value == null)
                {
                    return;
                }
                MainThreadCoreNumberValue = checked((byte)ConvertUtils.ConvertDecimalString(value, "Default/MainThreadCoreNumber"));
                _MainThreadCoreNumber = value;
            }
        }

        public const uint AlignMainThraedStackSize = 0x1000;
        [System.Xml.Serialization.XmlIgnore]
        public uint MainThreadStackSizeValue { get; set; }
        private string _MainThreadStackSize;
        [System.Xml.Serialization.XmlElement("MainThreadStackSize", IsNullable=false)]
        public string MainThreadStackSize
        {
            get { return _MainThreadStackSize; }
            set
            {
                if (value == null)
                {
                    return;
                }
                MainThreadStackSizeValue = checked((uint)ConvertUtils.ConvertHexString(value, "Default/MainThreadStackSize"));
                if ((MainThreadStackSizeValue & (AlignMainThraedStackSize - 1)) > 0)
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidAlignment, "Default/MainThreadStackSize", AlignMainThraedStackSize));
                }
                if (MainThreadStackSizeValue == 0)
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_Invalid0, "Default/MainThreadStackSize"));
                }
                _MainThreadStackSize = value;
            }
        }

        [System.Xml.Serialization.XmlElement("FsAccessControlData")]
        public FaDataModel  FsAccessControlData { get; set; }

        [System.Xml.Serialization.XmlElement("SrvAccessControlData")]
        public SaDataModel SrvAccessControlData { get; set; }

        [System.Xml.Serialization.XmlElement("KernelCapabilityData")]
        public KcDataModelWithSvcInfo KernelCapabilityData { get; set; }

        public void CheckReadSuccess()
        {
            if (Is64BitInstruction == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Default/Is64BitInstruction"));
            }
            if (ProcessAddressSpace == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Default/ProcessAddressSpace"));
            }
            if (MainThreadPriority == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Default/MainThreadPriority"));
            }
            if (MainThreadCoreNumber == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Default/MainThreadCoreNumber"));
            }
            if (MainThreadStackSize == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Default/MainThreadStackSize"));
            }
        }
    }
}
