﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeInitialProcessImage
{
    internal class Program
    {
        public static void Main(string[] args)
        {
            var argParser = new MakeInitialProcessImageArgParser();
            try
            {
                argParser.Parse(args);
            }
            catch (ArgumentException)
            {
                Environment.Exit(1);
            }

            if (!argParser.ExecutionRequested)
            {
                return;
            }

            try
            {
                var generator = new InitialProcessImageGenerator();
                generator.Generate(argParser.Params.OutputPath, argParser.Params.InputPaths);
            }
            catch (MakeInitialProcessImageException e)
            {
                Console.Error.WriteLine(e.Message);
                Environment.Exit(1);
            }
        }
    }
}
