﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace MakeInitialProcessImage
{
    /// <summary>
    /// MakeInitialProcessImage プログラムのパラメータを表します。
    /// </summary>
    internal class MakeInitialProcessImageParams
    {
        public MakeInitialProcessImageParams()
        {
            InputPaths = new string[0];
        }

        /// <summary>
        /// 出力先のパス。
        /// </summary>
        [CommandLineOption('o',
            IsRequired = true,
            Description = "Place the output into <Path>.",
            ValueName = "path")]
        public string OutputPath { get; set; }

        /// <summary>
        /// 入力のパス。
        /// </summary>
        [CommandLineValues(
            Description = "Input .kip files.",
            ValueName = ".kip path")]
        public string[] InputPaths { get; set; }
    }
}
