﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace MakeInitialProcessImage
{
    internal class MakeInitialProcessImageArgParser
    {
        /// <summary>
        /// コマンドライン引数の解析結果
        /// </summary>
        public MakeInitialProcessImageParams Params { get; private set; }
        /// <summary>
        /// コマンドの実際の処理が必要であるかどうか（すなわち、--help や --version フラグが指定されていない）
        /// </summary>
        public bool ExecutionRequested { get; private set; }

        /// <summary>
        /// コマンドライン引数を解析し、Params と ExecutionRequested を設定します。
        /// </summary>
        /// <param name="args">コマンドライン引数</param>
        public void Parse(string[] args)
        {
            var parser = CreateParser();

            var result = new MakeInitialProcessImageParams();
            ExecutionRequested = parser.ParseArgs(args, out result);
            this.Params = result;
        }

        private static CommandLineParser CreateParser()
        {
            return new CommandLineParser(new CommandLineParserSettings()
            {
                ApplicationDescription = "Creates an INITIAL_PRCESS image from .kip files."
            });
        }
    }
}
