﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeFirmwareArchive
{
    //!< 属性を持ったコンテンツのリストを表します
    public class ContentAttribute
    {
        public string Name { get; set; }
        public HashSet<string> Path { get; set; }

        public ContentAttribute()
        {
            Path = new HashSet<string>();
        }

        public ContentAttribute(HashSet<string> path)
        {
            Path = path;
        }

        public static int CompareTo(ContentAttribute a, ContentAttribute b)
        {
            return a.Name.CompareTo(b.Name);
        }
    }

    //!< ファームウェアアーカイブのコンフィグを表します
    public class FirmwareArchiveConfig
    {
        public string Name { get; set; }
        public string Description { get; set; }
        public HashSet<ContentAttribute> Attributes { get; set; }

        public FirmwareArchiveConfig()
        {
            Attributes = new HashSet<ContentAttribute>();
        }

        public FirmwareArchiveConfig(HashSet<ContentAttribute> attributes)
        {
            Attributes = attributes;
        }
    }
}
