﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Xml;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeDesc
{
    /// <summary>
    /// XML の共通操作をまとめたクラス
    /// </summary>
    public class XmlUtil
    {
        public static XmlElement CreateValueElement(XmlDocument xml, string elemName, string value)
        {
            XmlElement elem = xml.CreateElement(elemName);
            XmlNode node = xml.CreateNode(XmlNodeType.Text, elemName, string.Empty);
            node.InnerText = value;
            elem.AppendChild(node);
            return elem;
        }

        public static string ReadXmlSingleElementValue(XmlDocument xml, string nodeName, bool isRequired)
        {
            XmlNodeList list = xml.SelectNodes(nodeName);
            switch (list.Count)
            {
                case 0:
                    if (isRequired)
                    {
                        throw new ArgumentException(string.Format(Properties.Resources.Message_NotFoundElement, nodeName));
                    }
                    break;
                case 1:
                    return list[0].InnerText;
                default:
                    throw new ArgumentException(string.Format(Properties.Resources.Message_DuplicateElements, nodeName));
            }
            return null;
        }
    }
}
