﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace MakeDesc
{
    internal class MakeDescParams
    {
        [CommandLineOption("desc",
            IsRequired = true,
            Description = "Option_InputDescDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Path")]
        public string InputDescPath { get; set; }

        [CommandLineOption("key",
            IsRequired = false,
            Description = "Option_InputKeyDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Path")]
        public string KeyPath { get; set; }

        [CommandLineOption('o',
            IsRequired = true,
            Description = "Option_OutputDescDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Path")]
        public string OutputDescPath { get; set; }

        [CommandLineOption("svc_header",
            IsRequired = false,
            Description = "Option_InputSvcHeaderDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Path")]
        public string[] SvcHeaderPath { get; set; }

        [CommandLineOption("kernel_version",
            IsRequired = false,
            Description = "Option_KernelVersionDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Version")]
        public string KernelVersion { get; set; }

        [CommandLineOption("desc_version",
            IsRequired = false,
            Description = "Option_DescVersionDescription",
            DescriptionConverterName = "LocalizeDescription",
            ValueName = "Version")]
        public string DescVersion { get; set; }

        /// <summary>
        /// ローカライズしたオプションの説明を取得します。
        /// </summary>
        /// <param name="description">Descriptionプロパティの値</param>
        /// <param name="valueName">引数名またはオプション名</param>
        /// <returns>ローカライズされたコマンドラインオプショ
        public static string LocalizeDescription(string description, string valueName)
        {
            string result = Properties.Resources.ResourceManager.GetString(description, Properties.Resources.Culture);
            System.Diagnostics.Debug.Assert(result != null, "コマンドオプションの Description が null");

            return result;
        }
    }
}
