﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_RsaPssSha256Signer.h>
#include <nn/crypto/crypto_RsaPssSha256Verifier.h>

namespace Nintendo { namespace MakeDesc { namespace CryptoLibrary {

using namespace System;

    public ref class Rsa2048PssSha256SignCryptoDriver
    {
    public:
        const int KeySize;

        Rsa2048PssSha256SignCryptoDriver() : KeySize(256)
        {
        }

        array<Byte>^ SignBlock(array<Byte>^ keyModulus, array<Byte>^ keyPrivateExponent,
                               array<Byte>^ src, int srcOffset, int srcSize)
        {
            array<unsigned char>^ dst = gcnew array<unsigned char>(KeySize);
            array<unsigned char>^ salt = gcnew array<unsigned char>(nn::crypto::Rsa2048PssSha256Signer::DefaultSaltSize);
            m_Rng.GetBytes(salt);
            {
                pin_ptr<unsigned char> pinKeyModulus = &keyModulus[0];
                pin_ptr<unsigned char> pinKeyPrivateExponent = &keyPrivateExponent[0];
                pin_ptr<unsigned char> pinSrc = &src[srcOffset];
                pin_ptr<unsigned char> pinDst = &dst[0];
                pin_ptr<unsigned char> pinSalt = &salt[0];

                nn::crypto::SignRsa2048PssSha256(pinDst, KeySize,
                                              pinKeyModulus, keyModulus->Length,
                                              pinKeyPrivateExponent, keyPrivateExponent->Length,
                                              pinSrc, srcSize,
                                              pinSalt, salt->Length);

                pinKeyModulus = nullptr;
                pinKeyPrivateExponent = nullptr;
                pinSrc = nullptr;
                pinDst = nullptr;
                pinSalt = nullptr;
            }
            return dst;
        }

        bool VerifyBlock(array<Byte>^ keyModulus, array<Byte>^ keyPublicExponent,
                         array<Byte>^ signature, int signatureOffset, int signatureSize,
                         array<Byte>^ block, int blockOffset, int blockSize)
        {
            bool check = false;
            {
                pin_ptr<unsigned char> pinKeyModulus = &keyModulus[0];
                pin_ptr<unsigned char> pinKeyPublicExponent = &keyPublicExponent[0];
                pin_ptr<unsigned char> pinSignature = &signature[signatureOffset];
                pin_ptr<unsigned char> pinBlock = &block[blockOffset];

                check = nn::crypto::VerifyRsa2048PssSha256(pinSignature, signatureSize,
                                                        pinKeyModulus, keyModulus->Length,
                                                        pinKeyPublicExponent, keyPublicExponent->Length,
                                                        pinBlock, blockSize);

                pinKeyModulus = nullptr;
                pinKeyPublicExponent = nullptr;
                pinSignature = nullptr;
                pinBlock = nullptr;
            }
            return check;
        }
    private:
        System::Security::Cryptography::RNGCryptoServiceProvider m_Rng;

    };

}}}
