﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeAddrRegionHeader
{
    internal class FilePosition
    {
        public string Path { get; private set; }
        public int LineNumber { get; private set; }

        public FilePosition(string path, int lineNumber)
        {
            this.Path = path;
            this.LineNumber = lineNumber;
        }

        public override string ToString()
        {
            return string.Format(CultureInfo.InvariantCulture, "{0} ({1})", Path, LineNumber);
        }
    }

    internal class ParseContext
    {
        public AddrWidth AddrWidth { get; private set; }
        public FilePosition Position { get; private set; }

        public ParseContext(AddrWidth addrWidth, FilePosition position)
        {
            this.AddrWidth = addrWidth;
            this.Position = position;
        }
    }
}
