﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeAddrRegionHeader
{
    [Serializable]
    public class MakeAddrRegionHeaderException : Exception
    {
        public MakeAddrRegionHeaderException() { }
        public MakeAddrRegionHeaderException(string message) : base(message) { }
        public MakeAddrRegionHeaderException(string message, Exception inner) : base(message, inner) { }
        protected MakeAddrRegionHeaderException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }

    [Serializable]
    public class SyntaxErrorException : MakeAddrRegionHeaderException
    {
        public SyntaxErrorException() { }
        public SyntaxErrorException(string message) : base(message) { }
        public SyntaxErrorException(string message, Exception inner) : base(message, inner) { }
        protected SyntaxErrorException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }

    [Serializable]
    public class AddrRangeException : MakeAddrRegionHeaderException
    {
        public AddrRangeException() { }
        public AddrRangeException(string message) : base(message) { }
        public AddrRangeException(string message, Exception inner) : base(message, inner) { }
        protected AddrRangeException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }

    [Serializable]
    public class AddrOverflowException : MakeAddrRegionHeaderException
    {
        public AddrOverflowException() { }
        public AddrOverflowException(string message) : base(message) { }
        public AddrOverflowException(string message, Exception inner) : base(message, inner) { }
        protected AddrOverflowException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }

    [Serializable]
    public class DuplicatedNameException : MakeAddrRegionHeaderException
    {
        public DuplicatedNameException() { }
        public DuplicatedNameException(string message) : base(message) { }
        public DuplicatedNameException(string message, Exception inner) : base(message, inner) { }
        protected DuplicatedNameException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }

    [Serializable]
    public class UndefinedNameException : MakeAddrRegionHeaderException
    {
        public UndefinedNameException() { }
        public UndefinedNameException(string message) : base(message) { }
        public UndefinedNameException(string message, Exception inner) : base(message, inner) { }
        protected UndefinedNameException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }
}
