﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace Nintendo.Htcs
{
    public class PortMap : IEnumerable<PortMapItem>
    {
        private List<PortMapItem> items = new List<PortMapItem>();

        public PortMap()
        {
        }

        internal PortMap(XElement xElement)
        {
            items.AddRange(
                xElement.Elements(PortMapItem.XElementName).Select(x => new PortMapItem(x)));
        }

        // TORIAEZU ユーザに渡した後は呼ばないこと
        internal void Add(PortMapItem item)
        {
            items.Add(item);
        }

        // TORIAEZU ユーザに渡した後は呼ばないこと
        internal void Remove(HtcsPortDescriptor htcsPortDescriptor)
        {
            items.RemoveAt(items.FindIndex(s => s.HtcsPortDescriptor == htcsPortDescriptor));
        }

        public const string XElementName = "PortMap";
        internal XElement ToXElement()
        {
            return new XElement(XElementName,
                items.Select(s => s.ToXElement()));
        }

        #region IEnumerable<PortMapItem> メンバー

        public IEnumerator<PortMapItem> GetEnumerator()
        {
            return items.GetEnumerator();
        }

        #endregion

        #region IEnumerable メンバー

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            return items.GetEnumerator();
        }

        #endregion
    }
}
