﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Threading.Tasks;

namespace HtcDaemon
{
    internal class TargetPortManager : IDisposable
    {
        private bool disposed;
        private Dictionary<string, IHostAppListener> registeredPorts = new Dictionary<string, IHostAppListener>();

        public TargetPortManager()
        {
        }

        ~TargetPortManager()
        {
            this.Dispose(false);
        }

        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(this);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    // ここでマネージドリソースをDisposeする
                    foreach (var port in registeredPorts.Values)
                    {
                        port.Dispose();
                    }
                    registeredPorts.Clear();
                }

                // ここでアンマネージドリソースを解放する
                this.disposed = true;
            }
        }

        public void RegisterTargetPort(string portName, IHostAppListener hostAppListener)
        {
            registeredPorts[portName] = hostAppListener;
        }

        // KeyNotFoundException
        public void UnregisterTargetPort(string portName)
        {
            var port = registeredPorts[portName];
            port.Dispose();
            registeredPorts.Remove(portName);
        }

        // KeyNotFoundException
        public Socket Accept(string portName)
        {
            return registeredPorts[portName].Accept();
        }
    }
}
