﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Htcs;

namespace HtcDaemon
{
    internal class StaticPortMapBuilder : IEnumerable<KeyValuePair<HtcsPortDescriptor, int>>
    {
        private bool built;
        private Dictionary<HtcsPortDescriptor, int> portMap = new Dictionary<HtcsPortDescriptor, int>();

        public StaticPortMapBuilder()
        {
        }

        public void Add(HtcsPortDescriptor descriptor, int port)
        {
            portMap.Add(descriptor, port);
        }

        public StaticPortMap Build()
        {
            if (built)
            {
                throw new InvalidOperationException("StaticPortMapBuilder.Build は一度しか呼ぶことができません。");
            }

            built = true;
            return new StaticPortMap(portMap);
        }

        #region IEnumerable<KeyValuePair<HtcsPortDescriptor,int>> メンバー

        public IEnumerator<KeyValuePair<HtcsPortDescriptor, int>> GetEnumerator()
        {
            return portMap.GetEnumerator();
        }

        #endregion

        #region IEnumerable メンバー

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            return portMap.GetEnumerator();
        }

        #endregion
    }

    internal class StaticPortMap
    {
        private IDictionary<HtcsPortDescriptor, int> portMap;

        public StaticPortMap(IDictionary<HtcsPortDescriptor, int> portMap)
        {
            this.portMap = portMap;
        }

        public bool TryGetValue(HtcsPortDescriptor descriptor, out int port)
        {
            return portMap.TryGetValue(descriptor, out port);
        }
    }
}
