﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HtcDaemon
{
    internal static class HtcConstants
    {
        static HtcConstants()
        {
            Debug.Assert(0 < MessageBodyLengthMax && MessageBodyLengthMax <= ushort.MaxValue, "MessageBodyLengthMax は 0 でない 16 ビットの数値である必要があります。");
        }

        public static readonly Guid UsbDeviceGuid = new Guid("97FFFD48-2D1D-47A0-85A3-07FDE6FA0143");

        public const int TargetListenUdpPortSerialConnection = 8008;

        public const int TargetListenUdpPort = 8009;
        public const int HostAppTcpPort = 8002;
        public const int HtcPortNameLength = 32;

        public const int DefaultTargetTcpPort = 8009;

        public const int MessageBodyLengthMax = 65535;

        public const int ControlChannelId = 0;

        public const int HtcChannelCountMax = 256;
    }
}
