﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace HtcDaemon
{
    // TODO: HostDaemon から取得するようにするか検討する
    internal class HostPortManager
    {
        private Dictionary<string, IPEndPoint> registeredPorts = new Dictionary<string, IPEndPoint>();

        public HostPortManager()
        {
        }

        public void RegisterHostPort(string portName, IPEndPoint endPoint)
        {
            lock (registeredPorts)
            {
                registeredPorts[portName] = endPoint;
            }
        }

        // KeyNotFoundException
        public void UnregisterHostPort(string portName)
        {
            lock (registeredPorts)
            {
                registeredPorts.Remove(portName);
            }
        }

        // KeyNotFoundException
        public IPEndPoint GetEndPoint(string portName)
        {
            lock (registeredPorts)
            {
                return registeredPorts[portName];
            }
        }
    }
}
