﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Nintendo.Htcs;

namespace HtcDaemon.DirectSocket
{
    internal class DirectSocketHostTargetConnectionBuilder
    {
        public HostTargetConnection Build(Socket socket)
        {
            var targetEndPoint = (IPEndPoint)socket.RemoteEndPoint;

            var initialPacket = ReceiveInitialPacket(socket);
            var mux = new DirectSocketMux(socket, initialPacket.TargetPeerName);

            return new HostTargetConnection(mux, new DirectSocketControlCommunicator(mux, targetEndPoint));
        }

        private static InitialPacket ReceiveInitialPacket(Socket socket)
        {
            var stream = new NetworkStream(socket, false);
            using (var br = new BinaryReader(stream, Encoding.Unicode, true))
            {
                var protocolVersion = br.ReadUInt16();
                br.ReadBytes(6);
                var targetPeerNameBytes = br.ReadBytes(InitialPacket.PeerNameLength);
                var targetPeerName = new HtcsPeerName(StringUtil.StringFromCStyleString(targetPeerNameBytes));
                return new InitialPacket(protocolVersion, targetPeerName);
            }
        }

        private class InitialPacket
        {
            public const int PeerNameLength = 32;

            public InitialPacket(ushort protocolVersion, HtcsPeerName targetPeerName)
            {
                this.ProtocolVersion = protocolVersion;
                this.TargetPeerName = targetPeerName;
            }

            public ushort ProtocolVersion { get; private set; }
            public HtcsPeerName TargetPeerName { get; private set; }
        }
    }
}
