﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading.Tasks;

namespace HtcDaemon.DirectSocket
{
    // DirectSocket ではターゲット自身が socket の listen を行っているため、
    // ターゲット端点を保持するのみ。
    internal class DirectSocketHostAppListener : IHostAppListener
    {
        public DirectSocketHostAppListener(IPEndPoint endPoint)
        {
            this.LocalEndPoint = endPoint;
        }

        public void Dispose()
        {
            GC.SuppressFinalize(this);
        }

        public Socket Accept()
        {
            // DirectSocket では、HtcDaemon 側で Accept することはない
            throw new NotSupportedException();
        }

        public IPEndPoint LocalEndPoint { get; private set; }
    }
}
