﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.FsFileCacheSimulator.Simulation
{
    internal class CacheStatistics
    {
        public int CacheSearchCount { get; set; }
        public int CacheHitCount { get; set; }
        public double CacheHitRatio => CacheSearchCount > 0 ? CacheHitCount / (double)CacheSearchCount : 0.0;

        public int ReadAheadCount { get; set; }
        public int ReadAheadHitCount { get; set; }
        public double ReadAheadHitRatio => ReadAheadCount > 0 ? ReadAheadHitCount / (double)ReadAheadCount : 0.0;

        public TimeSpan ReadCacheOverhead { get; set; }
        public TimeSpan WriteCacheOverhead { get; set; }
    }
}
