﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.FsFileCacheSimulator
{
    internal class Log
    {
        public static Log Default { get; } = new Log();

        public enum Verbosity : int
        {
            Error = 0,
            Warning = 1,
            Message = 2,
            Verbose = 3,
            Debug = 4,
        }

        public Verbosity MinimumLoggingVerbosity { get; set; } = Verbosity.Message;

        private bool ShouldLogOfVerbosity(Verbosity verbosity)
        {
            return verbosity <= MinimumLoggingVerbosity;
        }

        public void ErrorLine()
        {
            ErrorLine(string.Empty);
        }
        public void ErrorLine(string format, params object[] args)
        {
            if (ShouldLogOfVerbosity(Verbosity.Error))
            {
                var color = Console.ForegroundColor;
                Console.ForegroundColor = ConsoleColor.Red;
                Console.Error.WriteLine("ERROR: " + string.Format(format, args));
                Console.ForegroundColor = color;
            }
        }

        public void WarningLine()
        {
            WarningLine(string.Empty);
        }
        public void WarningLine(string format, params object[] args)
        {
            if (ShouldLogOfVerbosity(Verbosity.Warning))
            {
                var color = Console.ForegroundColor;
                Console.ForegroundColor = ConsoleColor.Yellow;
                Console.Error.WriteLine("WARNING: " + string.Format(format, args));
                Console.ForegroundColor = color;
            }
        }

        public void MessageLine()
        {
            MessageLine(string.Empty);
        }
        public void MessageLine(string format, params object[] args)
        {
            if (ShouldLogOfVerbosity(Verbosity.Message))
            {
                var color = Console.ForegroundColor;
                Console.ForegroundColor = ConsoleColor.White;
                Console.WriteLine(format, args);
                Console.ForegroundColor = color;
            }
        }

        public void VerboseLine()
        {
            VerboseLine(string.Empty);
        }
        public void VerboseLine(string format, params object[] args)
        {
            if (ShouldLogOfVerbosity(Verbosity.Verbose))
            {
                var color = Console.ForegroundColor;
                Console.ForegroundColor = ConsoleColor.Cyan;
                Console.WriteLine("VERBOSE: " + string.Format(format, args));
                Console.ForegroundColor = color;
            }
        }

        public void DebugLine()
        {
            DebugLine(string.Empty);
        }
        public void DebugLine(string format, params object[] args)
        {
            if (ShouldLogOfVerbosity(Verbosity.Debug))
            {
                var color = Console.ForegroundColor;
                Console.ForegroundColor = ConsoleColor.Gray;
                Console.WriteLine("DEBUG: " + string.Format(format, args));
                Console.ForegroundColor = color;
            }
        }
    }
}
