﻿using DeviceTreeDataCollector;
using Nintendo.ToolFoundation.CommandLine;
using System;

namespace MakePartialDesc
{
    public class Program
    {
        public static void Main(string[] args)
        {
            try
            {
                // 入力引数をパースして option に展開
                var option = new ProgramArgument();
                var parser = new DelegateBasedCommandLineParser();
                parser.AddHelp(Console.WriteLine);
                option.RegisterWith(parser);
                if (!parser.ParseArgs(args, Console.WriteLine))
                {
                    Environment.Exit(1);
                }

                var dataCollector = new DeviceTreeDataCollector.DeviceTreeDataCollector(option.DataCollectParameterPath);
                dataCollector.DoCollection();

                var inputParameter = InputParameterParser.LoadFile(option.PartialDescParameterPath);

                var processor = new MakePartialDesc();
                processor.Process(inputParameter, dataCollector.GetCollectedProperty(), option.OutputPath);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine("*** Error ***");
                if (e.StackTrace != null)
                {
                    Console.WriteLine($"StackTrace: {e.StackTrace}");
                }
                if (e.Message != null)
                {
                    Console.WriteLine($"Message: {e.Message}");
                }
                if (e.InnerException != null)
                {
                    Console.WriteLine($"InnerException.Message: {e.InnerException.Message}");
                }
                Environment.Exit(1);
            }
        }
    }
}
