﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.ToolFoundation.CommandLine;

namespace MakePartialDesc
{
    internal sealed class ProgramArgument
    {
        /// <summary>
        /// 生成ファイルの出力先となる絶対パスを取得します。
        /// </summary>
        internal string OutputPath { get; private set; }

        /// <summary>
        /// Device Tree からのデータ収集に関するパラメータファイルの絶対パスを取得します。
        /// </summary>
        internal string DataCollectParameterPath { get; private set; }

        /// <summary>
        /// Partial desc 生成に関するパラメータファイルの絶対パスを取得します。
        /// </summary>
        internal string PartialDescParameterPath { get; private set; }

        internal void RegisterWith(DelegateBasedCommandLineParser parser)
        {
            parser.AddValueOption('d', "data-collect-param", this.SetDataCollectParameterPath)
                .SetDescription("specifies the parameter file for data collection from device tree")
                .SetRequired();

            parser.AddValueOption('p', "partial-desc-param", this.SetPartialDescParameterPath)
                .SetDescription("specifies the parameter file for partial desc generation")
                .SetRequired();

            parser.AddValueOption('o', "output", this.SetOutputPath)
                .SetDescription("specifies the output file")
                .SetRequired();
        }

        private void SetDataCollectParameterPath(string value)
        {
            this.DataCollectParameterPath = value;
        }

        private void SetPartialDescParameterPath(string value)
        {
            this.PartialDescParameterPath = value;
        }

        private void SetOutputPath(string value)
        {
            this.OutputPath = value;
        }
    }
}
